/*
 * Decompiled with CFR 0.152.
 */
package ec.gob.sri.dimm.ats.modelo.obj.asistente.valores;

import ec.gob.sri.anexo.texto.util.StringUtil;
import ec.gob.sri.dimm.api.colecciones.ElementoNombreValor;
import ec.gob.sri.dimm.api.modelo.ModeloValores;
import ec.gob.sri.dimm.ats.modelo.obj.Periodo;
import ec.gob.sri.dimm.data.impl.UtilCatalogosATS;
import java.math.BigDecimal;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class ModeloValoresCompVenta
implements ModeloValores {
    private boolean inicializado;
    private final Map<String, ElementoNombreValor<String>> tiposDeComprobantes = new LinkedHashMap<String, ElementoNombreValor<String>>();
    private final Map<String, ElementoNombreValor<String>> compensaciones;
    private Map<String, String> tiposDeEmisionDeComprobantes = new TreeMap<String, String>();
    private Periodo periodo;

    public ModeloValoresCompVenta(Periodo periodo) {
        this.compensaciones = new TreeMap<String, ElementoNombreValor<String>>();
        this.periodo = periodo;
    }

    public void inicializar() {
        if (!this.inicializado) {
            this.inicializado = true;
            this.cargarTiposDeEmisionDeComprobantes();
            this.cargarCompensacionesPorPeriodo();
        }
    }

    public void cargarTiposDeComprobantes(String tipoIdentificacion) {
        this.tiposDeComprobantes.clear();
        Map comprobantes = UtilCatalogosATS.crearInstancia().obtenerComprobantesPorTransaccionIdentificacionPeriodo("2", tipoIdentificacion, this.periodo.getAnio(), this.periodo.getMes());
        Map<String, String> mapaOrdenado = this.ordenarMapaString(comprobantes);
        for (Map.Entry<String, String> comp : mapaOrdenado.entrySet()) {
            this.tiposDeComprobantes.put(comp.getKey(), (ElementoNombreValor<String>)new ElementoNombreValor(String.valueOf(comp.getKey()) + "-" + comp.getValue(), (Object)comp.getKey()));
        }
    }

    private void cargarCompensacionesPorPeriodo() {
        this.compensaciones.clear();
        Map compensacionesVigentes = UtilCatalogosATS.crearInstancia().obtenerCompensacionesPorPeriodo(this.periodo.getFechaDeclarada());
        for (Map.Entry compensacion : compensacionesVigentes.entrySet()) {
            this.compensaciones.put((String)compensacion.getKey(), (ElementoNombreValor<String>)new ElementoNombreValor((String)((AbstractMap.SimpleEntry)compensacion.getValue()).getKey(), (Object)((String)compensacion.getKey())));
        }
    }

    public BigDecimal obtenerPorcentajeCompensacion(String codigoCompensacion) {
        Map compensacionesVigentes = UtilCatalogosATS.crearInstancia().obtenerCompensacionesPorPeriodo(this.periodo.getFechaDeclarada());
        if (compensacionesVigentes.containsKey(codigoCompensacion)) {
            return (BigDecimal)((AbstractMap.SimpleEntry)compensacionesVigentes.get(codigoCompensacion)).getValue();
        }
        throw new RuntimeException("No existe el porcentaje de compensacion");
    }

    private void cargarTiposDeEmisionDeComprobantes() {
        this.tiposDeEmisionDeComprobantes = UtilCatalogosATS.crearInstancia().obtenerTiposDeEmisionDeComprobantes();
    }

    public List<ElementoNombreValor<String>> getTiposDeComprobantes() {
        return new ArrayList<ElementoNombreValor<String>>(this.tiposDeComprobantes.values());
    }

    public ElementoNombreValor<String> obtenerTipoComprobante(String codigoTipoComprobante) {
        return StringUtil.isNullOrEmpty((String)codigoTipoComprobante) ? null : this.tiposDeComprobantes.get(codigoTipoComprobante);
    }

    public List<ElementoNombreValor<String>> getCompensaciones() {
        return new ArrayList<ElementoNombreValor<String>>(this.compensaciones.values());
    }

    public Map<String, String> getTiposDeEmisionDeComprobantes() {
        return this.tiposDeEmisionDeComprobantes;
    }

    private Map<String, String> ordenarMapaString(Map<String, String> comprobantes) {
        LinkedHashMap<String, String> comprobantesOrdenados = new LinkedHashMap<String, String>();
        ArrayList<String> listaAOrdenar = new ArrayList<String>();
        String guion = "-";
        for (Map.Entry<String, String> comprobante : comprobantes.entrySet()) {
            listaAOrdenar.add(String.valueOf(comprobante.getKey()) + guion + comprobante.getValue());
        }
        Collections.sort(listaAOrdenar, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return this.extractInt(o1) - this.extractInt(o2);
            }

            private int extractInt(String s) {
                String numero = s.replaceAll("\\D", "");
                return numero.isEmpty() ? 0 : Integer.parseInt(numero);
            }
        });
        for (String string : listaAOrdenar) {
            String[] partes = string.split(guion);
            comprobantesOrdenados.put(partes[0], partes[1]);
        }
        return comprobantesOrdenados;
    }
}

